/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class DmgcpuBW
implements ICpu {
    private final int F_ZERO;
    private final int F_SUBTRACT;
    private final int F_HALFCARRY;
    private final int F_CARRY;
    protected int INSTRS_PER_HBLANK = 60;
    protected int INSTRS_IN_MODE_0 = 30;
    protected int INSTRS_IN_MODE_0_2 = 40;
    protected int INSTRS_PER_DIV = 33;
    protected final int BASE_INSTRS_PER_HBLANK;
    protected final int BASE_INSTRS_IN_MODE_0;
    protected final int BASE_INSTRS_IN_MODE_0_2;
    protected final int BASE_INSTRS_PER_DIV;
    public final int INT_VBLANK;
    public final int INT_LCDC;
    public final int INT_TIMA;
    public final int INT_SER;
    public final int INT_P10;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int sp;
    private int hl;
    private byte[] decoderMemory;
    private int localPC;
    private int globalPC;
    private int decoderMaxCruise;
    private int instrCount;
    private int nextHBlank;
    private int nextTimaOverflow;
    private int nextInterruptEnable;
    private int nextTimedInterrupt;
    public boolean interruptsEnabled = false;
    public boolean interruptsArmed = false;
    protected boolean p10Requested;
    public byte[][] memory = new byte[8][];
    private byte[] mainRam;
    public byte[] oam = new byte[256];
    public byte[] registers = new byte[256];
    private int divReset;
    private int instrsPerTima = 131;
    private int buttonState;
    public GraphicsChipBW graphicsChip;
    public GBCanvas screen;
    public boolean terminate;
    private String cartName;
    private int cartType;
    private byte[][] rom;
    public byte[][] cartRam;
    private int currentRomBank = 1;
    int loadedRomBanks;
    private int[] romBankQueue;
    private int currentRamBank;
    private boolean mbc1LargeRamMode;
    private boolean cartRamEnabled;
    public byte[] rtcReg = new byte[5];
    private int lastRtcUpdate;
    private int[] incflags = new int[256];
    private int[] decflags = new int[256];
    private int[] romTouch;

    public DmgcpuBW(String cart, GBCanvas gbc) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.BASE_INSTRS_PER_HBLANK = 60;
        this.BASE_INSTRS_IN_MODE_0 = 30;
        this.BASE_INSTRS_IN_MODE_0_2 = 40;
        this.BASE_INSTRS_PER_DIV = 33;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.cartName = cart;
        this.initCartridge();
        this.screen = gbc;
        this.graphicsChip = new GraphicsChipBW(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.interruptsEnabled = false;
        this.f = 176;
        this.a = 1;
        this.b = 0;
        this.c = 19;
        this.d = 0;
        this.e = 216;
        this.hl = 333;
        this.setPC(256);
        this.sp = 65534;
        this.nextHBlank = this.INSTRS_PER_HBLANK;
        this.nextTimaOverflow = Integer.MAX_VALUE;
        this.nextInterruptEnable = Integer.MAX_VALUE;
        this.nextTimedInterrupt = this.INSTRS_PER_HBLANK;
        this.initIncDecFlags();
        this.ioHandlerReset();
    }

    public DmgcpuBW(String cart, GBCanvas gbc, byte[] flatState, int offset) {
        this.F_ZERO = 128;
        this.F_SUBTRACT = 64;
        this.F_HALFCARRY = 32;
        this.F_CARRY = 16;
        this.BASE_INSTRS_PER_HBLANK = 60;
        this.BASE_INSTRS_IN_MODE_0 = 30;
        this.BASE_INSTRS_IN_MODE_0_2 = 40;
        this.BASE_INSTRS_PER_DIV = 33;
        this.INT_VBLANK = 1;
        this.INT_LCDC = 2;
        this.INT_TIMA = 4;
        this.INT_SER = 8;
        this.INT_P10 = 16;
        this.cartName = cart;
        this.initCartridge();
        this.screen = gbc;
        this.graphicsChip = new GraphicsChipBW(this);
        this.memory[6] = this.mainRam;
        this.memory[7] = this.mainRam;
        this.unflatten(flatState, offset);
        this.initIncDecFlags();
    }

    private void initIncDecFlags() {
        int i;
        this.incflags[0] = 160;
        for (i = 16; i < 256; i += 16) {
            this.incflags[i] = 32;
        }
        this.decflags[0] = 192;
        for (i = 1; i < 256; ++i) {
            this.decflags[i] = 64 + ((i & 0xF) == 15 ? 32 : 0);
        }
    }

    private void unflatten(byte[] flatState, int offset) {
        int version;
        this.a = flatState[offset++] & 0xFF;
        this.b = flatState[offset++] & 0xFF;
        this.c = flatState[offset++] & 0xFF;
        this.d = flatState[offset++] & 0xFF;
        this.e = flatState[offset++] & 0xFF;
        this.f = flatState[offset++] & 0xFF;
        this.sp = flatState[offset++] & 0xFF;
        this.sp = (this.sp << 8) + (flatState[offset++] & 0xFF);
        this.hl = flatState[offset++] & 0xFF;
        this.hl = (this.hl << 8) + (flatState[offset++] & 0xFF);
        int pc = flatState[offset++] & 0xFF;
        pc = (pc << 8) + (flatState[offset++] & 0xFF);
        this.instrCount = GBCanvas.getInt(flatState, offset);
        this.nextHBlank = GBCanvas.getInt(flatState, offset += 4);
        this.nextTimaOverflow = GBCanvas.getInt(flatState, offset += 4);
        this.nextInterruptEnable = GBCanvas.getInt(flatState, offset += 4);
        this.nextTimedInterrupt = GBCanvas.getInt(flatState, offset += 4);
        offset += 4;
        if ((version = flatState[offset++] & 0xFF) <= 1) {
            this.interruptsEnabled = version != 0;
        } else if (version == 2) {
            this.interruptsEnabled = flatState[offset++] != 0;
        }
        this.interruptsArmed = flatState[offset++] != 0;
        System.arraycopy(flatState, offset, this.mainRam, 0, this.mainRam.length);
        System.arraycopy(flatState, offset += this.mainRam.length, this.oam, 0, 256);
        System.arraycopy(flatState, offset += 256, this.registers, 0, 256);
        this.divReset = GBCanvas.getInt(flatState, offset += 256);
        this.instrsPerTima = GBCanvas.getInt(flatState, offset += 4);
        this.cartType = GBCanvas.getInt(flatState, offset += 4);
        offset += 4;
        for (int i = 0; i < this.cartRam.length; ++i) {
            System.arraycopy(flatState, offset, this.cartRam[i], 0, 8192);
            offset += 8192;
        }
        this.currentRomBank = GBCanvas.getInt(flatState, offset);
        this.mapRom(this.currentRomBank);
        this.currentRamBank = GBCanvas.getInt(flatState, offset += 4);
        offset += 4;
        if (this.currentRamBank != 0) {
            this.mapRam(this.currentRamBank);
        }
        this.mbc1LargeRamMode = flatState[offset++] != 0;
        boolean bl = this.cartRamEnabled = flatState[offset++] != 0;
        if (version == 2) {
            System.arraycopy(flatState, offset, this.rtcReg, 0, this.rtcReg.length);
            offset += this.rtcReg.length;
        }
        offset = this.graphicsChip.unflatten(flatState, offset);
        this.setPC(pc);
        if (offset != flatState.length) {
            throw new RuntimeException("unflatten offset error:" + offset + ", " + flatState.length);
        }
    }

    public byte[] flatten() {
        int offset;
        int size = this.cartName.length() + 1 + 35 + this.mainRam.length + 512 + 12 + 8192 * this.cartRam.length + 10 + 8192 + 48 + 6 + this.rtcReg.length;
        byte[] flatState = new byte[size];
        for (offset = 0; offset < this.cartName.length(); ++offset) {
            flatState[offset] = (byte)this.cartName.charAt(offset);
        }
        flatState[offset++] = 0;
        flatState[offset++] = (byte)this.a;
        flatState[offset++] = (byte)this.b;
        flatState[offset++] = (byte)this.c;
        flatState[offset++] = (byte)this.d;
        flatState[offset++] = (byte)this.e;
        flatState[offset++] = (byte)this.f;
        flatState[offset++] = (byte)(this.sp >> 8);
        flatState[offset++] = (byte)this.sp;
        flatState[offset++] = (byte)(this.hl >> 8);
        flatState[offset++] = (byte)this.hl;
        int pc = this.localPC + this.globalPC;
        flatState[offset++] = (byte)(pc >> 8);
        flatState[offset++] = (byte)pc;
        GBCanvas.setInt(flatState, offset, this.instrCount);
        GBCanvas.setInt(flatState, offset += 4, this.nextHBlank);
        GBCanvas.setInt(flatState, offset += 4, this.nextTimaOverflow);
        GBCanvas.setInt(flatState, offset += 4, this.nextInterruptEnable);
        GBCanvas.setInt(flatState, offset += 4, this.nextTimedInterrupt);
        offset += 4;
        flatState[offset++] = 2;
        flatState[offset++] = (byte)(this.interruptsEnabled ? 1 : 0);
        flatState[offset++] = (byte)(this.interruptsArmed ? 1 : 0);
        System.arraycopy(this.mainRam, 0, flatState, offset, this.mainRam.length);
        System.arraycopy(this.oam, 0, flatState, offset += this.mainRam.length, 256);
        System.arraycopy(this.registers, 0, flatState, offset += 256, 256);
        GBCanvas.setInt(flatState, offset += 256, this.divReset);
        GBCanvas.setInt(flatState, offset += 4, this.instrsPerTima);
        GBCanvas.setInt(flatState, offset += 4, this.cartType);
        offset += 4;
        for (int j = 0; j < this.cartRam.length; ++j) {
            System.arraycopy(this.cartRam[j], 0, flatState, offset, 8192);
            offset += 8192;
        }
        GBCanvas.setInt(flatState, offset, this.currentRomBank);
        GBCanvas.setInt(flatState, offset += 4, this.currentRamBank);
        offset += 4;
        flatState[offset++] = (byte)(this.mbc1LargeRamMode ? 1 : 0);
        flatState[offset++] = (byte)(this.cartRamEnabled ? 1 : 0);
        System.arraycopy(this.rtcReg, 0, flatState, offset, this.rtcReg.length);
        offset += this.rtcReg.length;
        offset = this.graphicsChip.flatten(flatState, offset);
        if (offset != flatState.length) {
            throw new RuntimeException("flatten offset error:" + Integer.toString(offset, 16) + ", " + Integer.toString(flatState.length, 16));
        }
        return flatState;
    }

    public final int addressRead(int addr) {
        if (addr < 40960) {
            return this.memory[addr >> 13][addr & 0x1FFF];
        }
        if (addr < 49152) {
            if (this.currentRamBank >= 8) {
                this.rtcSync();
                return this.rtcReg[this.currentRamBank - 8];
            }
            return this.memory[addr >> 13][addr & 0x1FFF];
        }
        if (addr < 65024) {
            return this.mainRam[addr & 0x1FFF];
        }
        if (addr < 65280) {
            return this.oam[addr - 65024] & 0xFF;
        }
        return this.ioRead(addr - 65280);
    }

    public final void addressWrite(int addr, int data) {
        int bank = addr >> 13;
        switch (bank) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.cartridgeWrite(addr, data);
                break;
            }
            case 4: {
                this.graphicsChip.addressWrite(addr - 32768, (byte)data);
                break;
            }
            case 5: {
                this.cartridgeWrite(addr, data);
                break;
            }
            case 6: {
                this.mainRam[addr - 49152] = (byte)data;
                break;
            }
            case 7: {
                if (addr < 65024) {
                    this.mainRam[addr - 57344] = (byte)data;
                    break;
                }
                if (addr < 65280) {
                    this.oam[addr - 65024] = (byte)data;
                    break;
                }
                this.ioWrite(addr - 65280, data);
            }
        }
    }

    private final void pushPC() {
        int pc = this.globalPC + this.localPC;
        if (this.sp >> 13 == 6) {
            this.mainRam[--this.sp - 49152] = (byte)(pc >> 8);
            this.mainRam[--this.sp - 49152] = (byte)pc;
        } else {
            this.addressWrite(--this.sp, pc >> 8);
            this.addressWrite(--this.sp, pc & 0xFF);
        }
    }

    private final void popPC() {
        if (this.sp >> 13 == 6) {
            this.setPC((this.mainRam[this.sp++ - 49152] & 0xFF) + ((this.mainRam[this.sp++ - 49152] & 0xFF) << 8));
        } else {
            this.setPC((this.addressRead(this.sp++) & 0xFF) + ((this.addressRead(this.sp++) & 0xFF) << 8));
        }
    }

    private final int registerRead(int regNum) {
        switch (regNum) {
            case 0: {
                return this.b;
            }
            case 1: {
                return this.c;
            }
            case 2: {
                return this.d;
            }
            case 3: {
                return this.e;
            }
            case 4: {
                return this.hl >> 8;
            }
            case 5: {
                return this.hl & 0xFF;
            }
            case 6: {
                return this.addressRead(this.hl) & 0xFF;
            }
            case 7: {
                return this.a;
            }
        }
        return -1;
    }

    private final void registerWrite(int regNum, int data) {
        switch (regNum) {
            case 0: {
                this.b = data;
                return;
            }
            case 1: {
                this.c = data;
                return;
            }
            case 2: {
                this.d = data;
                return;
            }
            case 3: {
                this.e = data;
                return;
            }
            case 4: {
                this.hl = this.hl & 0xFF | data << 8;
                return;
            }
            case 5: {
                this.hl = this.hl & 0xFF00 | data;
                return;
            }
            case 6: {
                this.addressWrite(this.hl, data);
                return;
            }
            case 7: {
                this.a = data;
                return;
            }
        }
    }

    private final void checkInterrupts() {
        if (this.p10Requested) {
            this.p10Requested = false;
            if ((this.registers[255] & 0x10) != 0) {
                this.registers[15] = (byte)(this.registers[15] | 0x10);
            }
            boolean bl = this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
            if (!this.interruptsArmed) {
                return;
            }
        }
        this.pushPC();
        int mask = this.registers[255] & this.registers[15];
        if ((mask & 1) != 0) {
            this.setPC(64);
            this.registers[15] = (byte)(this.registers[15] - 1);
        } else if ((mask & 2) != 0) {
            this.setPC(72);
            this.registers[15] = (byte)(this.registers[15] - 2);
        } else if ((mask & 4) != 0) {
            this.setPC(80);
            this.registers[15] = (byte)(this.registers[15] - 4);
        } else if ((mask & 8) != 0) {
            this.setPC(88);
            this.registers[15] = (byte)(this.registers[15] - 8);
        } else if ((mask & 0x10) != 0) {
            this.setPC(96);
            this.registers[15] = (byte)(this.registers[15] - 16);
        } else {
            throw new RuntimeException("concurrent modification exception: " + mask + " " + this.registers[255] + " " + this.registers[15]);
        }
        this.interruptsEnabled = false;
        this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
    }

    private final void initiateInterrupts() {
        if (this.instrCount - this.nextHBlank >= 0) {
            this.nextHBlank += this.INSTRS_PER_HBLANK;
            this.registers[68] = (byte)(this.registers[68] + 1);
            int line = this.registers[68] & 0xFF;
            if (line == 153) {
                this.registers[68] = 0;
                line = 0;
            }
            if (line < 144) {
                this.graphicsChip.notifyScanline(line);
                if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 2) != 0) {
                    if ((this.registers[65] & 0x40) != 0 && (this.registers[69] & 0xFF) == line) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    } else if ((this.registers[65] & 8) != 0) {
                        this.interruptsArmed = true;
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    }
                }
            } else if (line == 144) {
                this.graphicsChip.vBlank();
                if ((this.registers[64] & 0x80) != 0 && (this.registers[255] & 1) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 1);
                    if ((this.registers[65] & 0x10) != 0 && (this.registers[255] & 2) != 0) {
                        this.registers[15] = (byte)(this.registers[15] | 2);
                    }
                }
            }
            this.nextTimedInterrupt = this.nextHBlank - this.nextTimaOverflow < 0 ? this.nextHBlank : this.nextTimaOverflow;
            this.nextTimedInterrupt = this.nextInterruptEnable - this.nextTimedInterrupt < 0 ? this.nextInterruptEnable : this.nextTimedInterrupt;
        } else if (this.instrCount - this.nextTimaOverflow >= 0) {
            this.nextTimaOverflow += this.instrsPerTima * (256 - this.registers[6]);
            if ((this.registers[255] & 4) != 0) {
                this.interruptsArmed = true;
                this.registers[15] = (byte)(this.registers[15] | 4);
            }
            this.nextTimedInterrupt = this.nextHBlank - this.nextTimaOverflow < 0 ? this.nextHBlank : this.nextTimaOverflow;
            this.nextTimedInterrupt = this.nextInterruptEnable - this.nextTimedInterrupt < 0 ? this.nextInterruptEnable : this.nextTimedInterrupt;
        } else if (this.instrCount - this.nextInterruptEnable >= 0) {
            this.interruptsEnabled = true;
            this.nextInterruptEnable = Integer.MAX_VALUE;
            this.nextTimedInterrupt = this.nextHBlank - this.nextTimaOverflow < 0 ? this.nextHBlank : this.nextTimaOverflow;
        }
    }

    public final void setPC(int pc) {
        if (pc < 65280) {
            this.decoderMemory = this.memory[pc >> 13];
            this.localPC = pc & 0x1FFF;
            this.globalPC = pc & 0xE000;
            this.decoderMaxCruise = pc < 57344 ? 8189 : 7677;
        } else {
            this.decoderMemory = this.registers;
            this.localPC = pc & 0xFF;
            this.globalPC = 65280;
            this.decoderMaxCruise = 253;
        }
    }

    private final void executeShift(int b2) {
        int regNum = b2 & 7;
        int data = this.registerRead(regNum);
        if ((b2 & 0xC0) == 0) {
            switch (b2 & 0xF8) {
                case 0: {
                    this.f = 0;
                    if (data >= 128) {
                        this.f = 16;
                    }
                    data = data << 1 & 0xFF;
                    if ((this.f & 0x10) == 0) break;
                    data |= 1;
                    break;
                }
                case 8: {
                    this.f = 0;
                    if ((data & 1) != 0) {
                        this.f = 16;
                    }
                    data >>= 1;
                    if ((this.f & 0x10) == 0) break;
                    data |= 0x80;
                    break;
                }
                case 16: {
                    int newf = data >= 128 ? 16 : 0;
                    data = data << 1 & 0xFF;
                    if ((this.f & 0x10) != 0) {
                        data |= 1;
                    }
                    this.f = newf;
                    break;
                }
                case 24: {
                    int newf = (data & 1) != 0 ? 16 : 0;
                    data >>= 1;
                    if ((this.f & 0x10) != 0) {
                        data |= 0x80;
                    }
                    this.f = newf;
                    break;
                }
                case 32: {
                    this.f = 0;
                    if ((data & 0x80) != 0) {
                        this.f = 16;
                    }
                    data = data << 1 & 0xFF;
                    break;
                }
                case 40: {
                    this.f = 0;
                    if ((data & 1) != 0) {
                        this.f = 16;
                    }
                    data = (data & 0x80) + (data >> 1);
                    break;
                }
                case 48: {
                    data = (data & 0xF) << 4 | data >> 4;
                    this.f = 0;
                    break;
                }
                case 56: {
                    this.f = 0;
                    if ((data & 1) != 0) {
                        this.f = 16;
                    }
                    data >>= 1;
                }
            }
            if (data == 0) {
                this.f |= 0x80;
            }
            this.registerWrite(regNum, data);
        } else {
            int bitMask = 1 << ((b2 & 0x38) >> 3);
            if ((b2 & 0xC0) == 64) {
                this.f = this.f & 0x10 | 0x20;
                if ((data & bitMask) == 0) {
                    this.f |= 0x80;
                }
            } else if ((b2 & 0xC0) == 128) {
                this.registerWrite(regNum, data & 255 - bitMask);
            } else if ((b2 & 0xC0) == 192) {
                this.registerWrite(regNum, data | bitMask);
            }
        }
    }

    private final void executeDAA() {
        int upperNibble = this.a >> 4 & 0xF;
        int lowerNibble = this.a & 0xF;
        int newf = this.f & 0x50;
        if ((this.f & 0x40) == 0) {
            if ((this.f & 0x10) == 0) {
                if (upperNibble <= 8 && lowerNibble >= 10 && (this.f & 0x20) == 0) {
                    this.a += 6;
                }
                if (upperNibble <= 9 && lowerNibble <= 3 && (this.f & 0x20) != 0) {
                    this.a += 6;
                }
                if (upperNibble >= 10 && lowerNibble <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                    newf |= 0x10;
                }
                if (upperNibble >= 9 && lowerNibble >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                    newf |= 0x10;
                }
                if (upperNibble >= 10 && lowerNibble <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                    newf |= 0x10;
                }
            } else {
                if (upperNibble <= 2 && lowerNibble <= 9 && (this.f & 0x20) == 0) {
                    this.a += 96;
                }
                if (upperNibble <= 2 && lowerNibble >= 10 && (this.f & 0x20) == 0) {
                    this.a += 102;
                }
                if (upperNibble <= 3 && lowerNibble <= 3 && (this.f & 0x20) != 0) {
                    this.a += 102;
                }
            }
        } else if ((this.f & 0x10) == 0) {
            if (upperNibble <= 8 && lowerNibble >= 6 && (this.f & 0x20) != 0) {
                this.a += 250;
            }
        } else {
            if (upperNibble >= 7 && lowerNibble <= 9 && (this.f & 0x20) == 0) {
                this.a += 160;
            }
            if (upperNibble >= 6 && lowerNibble >= 6 && (this.f & 0x20) != 0) {
                this.a += 154;
            }
        }
        this.a &= 0xFF;
        if (this.a == 0) {
            newf |= 0x80;
        }
        this.f = newf;
    }

    public final void run() {
        int startTime;
        this.terminate = false;
        int newf = 0;
        int f_szhc = 224;
        System.gc();
        this.graphicsChip.timer = startTime = (int)System.currentTimeMillis();
        while (!this.terminate) {
            int b3;
            int b2;
            int offset;
            int b1;
            ++this.instrCount;
            if (this.localPC <= this.decoderMaxCruise) {
                b1 = this.decoderMemory[this.localPC++] & 0xFF;
                offset = this.decoderMemory[this.localPC];
                b2 = offset & 0xFF;
                b3 = this.decoderMemory[this.localPC + 1];
            } else {
                int pc = this.localPC + this.globalPC;
                b1 = this.addressRead(pc++) & 0xFF;
                offset = this.addressRead(pc);
                b2 = offset & 0xFF;
                b3 = this.addressRead(pc + 1);
                this.setPC(pc);
            }
            switch (b1) {
                case 0: {
                    break;
                }
                case 1: {
                    this.localPC += 2;
                    this.b = b3 & 0xFF;
                    this.c = b2;
                    break;
                }
                case 2: {
                    this.addressWrite(this.b << 8 | this.c, this.a);
                    break;
                }
                case 3: {
                    ++this.c;
                    if (this.c != 256) break;
                    this.c = 0;
                    this.b = this.b + 1 & 0xFF;
                    break;
                }
                case 4: {
                    this.b = this.b + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.b];
                    break;
                }
                case 5: {
                    this.b = this.b - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.b];
                    break;
                }
                case 6: {
                    ++this.localPC;
                    this.b = b2;
                    break;
                }
                case 7: {
                    if (this.a >= 128) {
                        this.f = 16;
                        this.a = (this.a << 1) + 1 & 0xFF;
                        break;
                    }
                    if (this.a == 0) {
                        this.f = 128;
                        break;
                    }
                    this.a <<= 1;
                    this.f = 0;
                    break;
                }
                case 8: {
                    this.localPC += 2;
                    newf = ((b3 & 0xFF) << 8) + b2;
                    this.addressWrite(newf, this.sp);
                    this.addressWrite(newf + 1, this.sp >> 8);
                    break;
                }
                case 9: {
                    this.hl += (this.b << 8) + this.c;
                    if ((this.hl & 0xFFFF0000) != 0) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 10: {
                    this.a = this.addressRead((this.b << 8) + this.c) & 0xFF;
                    break;
                }
                case 11: {
                    --this.c;
                    if (this.c >= 0) break;
                    this.c = 255;
                    this.b = this.b - 1 & 0xFF;
                    break;
                }
                case 12: {
                    this.c = this.c + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.c];
                    break;
                }
                case 13: {
                    this.c = this.c - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.c];
                    break;
                }
                case 14: {
                    ++this.localPC;
                    this.c = b2;
                    break;
                }
                case 15: {
                    this.f = (this.a & 1) == 1 ? 16 : 0;
                    this.a >>= 1;
                    if ((this.f & 0x10) != 0) {
                        this.a |= 0x80;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 16: {
                    ++this.localPC;
                    break;
                }
                case 17: {
                    this.localPC += 2;
                    this.d = b3 & 0xFF;
                    this.e = b2;
                    break;
                }
                case 18: {
                    this.addressWrite((this.d << 8) + this.e, this.a);
                    break;
                }
                case 19: {
                    ++this.e;
                    if (this.e != 256) break;
                    this.e = 0;
                    this.d = this.d + 1 & 0xFF;
                    break;
                }
                case 20: {
                    this.d = this.d + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.d];
                    break;
                }
                case 21: {
                    this.d = this.d - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.d];
                    break;
                }
                case 22: {
                    ++this.localPC;
                    this.d = b2;
                    break;
                }
                case 23: {
                    newf = (this.a & 0x80) != 0 ? 16 : 0;
                    this.a <<= 1;
                    if ((this.f & 0x10) != 0) {
                        this.a |= 1;
                    }
                    this.a &= 0xFF;
                    if (this.a == 0) {
                        newf |= 0x80;
                    }
                    this.f = newf;
                    break;
                }
                case 24: {
                    this.localPC += 1 + offset;
                    if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                    this.setPC(this.localPC + this.globalPC);
                    break;
                }
                case 25: {
                    this.hl += (this.d << 8) + this.e;
                    if ((this.hl & 0xFFFF0000) != 0) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 26: {
                    this.a = this.addressRead((this.d << 8) + this.e) & 0xFF;
                    break;
                }
                case 27: {
                    --this.e;
                    if (this.e >= 0) break;
                    this.e = 255;
                    this.d = this.d - 1 & 0xFF;
                    break;
                }
                case 28: {
                    this.e = this.e + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.e];
                    break;
                }
                case 29: {
                    this.e = this.e - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.e];
                    break;
                }
                case 30: {
                    ++this.localPC;
                    this.e = b2;
                    break;
                }
                case 31: {
                    newf = (this.a & 1) != 0 ? 16 : 0;
                    this.a >>= 1;
                    if ((this.f & 0x10) != 0) {
                        this.a |= 0x80;
                    }
                    if (this.a == 0) {
                        newf |= 0x80;
                    }
                    this.f = newf;
                    break;
                }
                case 32: {
                    if (this.f < 128) {
                        this.localPC += 1 + offset;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 33: {
                    this.localPC += 2;
                    this.hl = ((b3 & 0xFF) << 8) + b2;
                    break;
                }
                case 34: {
                    this.addressWrite(this.hl++, this.a);
                    break;
                }
                case 35: {
                    this.hl = this.hl + 1 & 0xFFFF;
                    break;
                }
                case 36: {
                    b2 = (this.hl >> 8) + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[b2];
                    this.hl = (this.hl & 0xFF) + (b2 << 8);
                    break;
                }
                case 37: {
                    b2 = (this.hl >> 8) - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[b2];
                    this.hl = (this.hl & 0xFF) + (b2 << 8);
                    break;
                }
                case 38: {
                    ++this.localPC;
                    this.hl = this.hl & 0xFF | b2 << 8;
                    break;
                }
                case 39: {
                    this.executeDAA();
                    break;
                }
                case 40: {
                    if (this.f >= 128) {
                        this.localPC += 1 + offset;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 41: {
                    this.hl *= 2;
                    if ((this.hl & 0xFFFF0000) != 0) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 42: {
                    this.a = this.addressRead(this.hl++) & 0xFF;
                    break;
                }
                case 43: {
                    this.hl = this.hl - 1 & 0xFFFF;
                    break;
                }
                case 44: {
                    b2 = this.hl + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[b2];
                    this.hl = (this.hl & 0xFF00) + b2;
                    break;
                }
                case 45: {
                    b2 = this.hl - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[b2];
                    this.hl = (this.hl & 0xFF00) + b2;
                    break;
                }
                case 46: {
                    ++this.localPC;
                    this.hl = this.hl & 0xFF00 | b2;
                    break;
                }
                case 47: {
                    this.a = ~this.a & 0xFF;
                    this.f |= 0x60;
                    break;
                }
                case 48: {
                    if ((this.f & 0x10) == 0) {
                        this.localPC += 1 + offset;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 49: {
                    this.localPC += 2;
                    this.sp = ((b3 & 0xFF) << 8) + b2;
                    break;
                }
                case 50: {
                    this.addressWrite(this.hl--, this.a);
                    break;
                }
                case 51: {
                    this.sp = this.sp + 1 & 0xFFFF;
                    break;
                }
                case 52: {
                    b2 = this.addressRead(this.hl) + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[b2];
                    this.addressWrite(this.hl, b2);
                    break;
                }
                case 53: {
                    b2 = this.addressRead(this.hl) - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[b2];
                    this.addressWrite(this.hl, b2);
                    break;
                }
                case 54: {
                    ++this.localPC;
                    this.addressWrite(this.hl, b2);
                    break;
                }
                case 55: {
                    this.f = this.f & 0x80 | 0x10;
                    break;
                }
                case 56: {
                    if ((this.f & 0x10) != 0) {
                        this.localPC += 1 + offset;
                        if (this.localPC >= 0 && this.localPC <= this.decoderMaxCruise) break;
                        this.setPC(this.localPC + this.globalPC);
                        break;
                    }
                    ++this.localPC;
                    break;
                }
                case 57: {
                    this.hl += this.sp;
                    if (this.hl > 65535) {
                        this.f = this.f & 0x80 | 0x10;
                        this.hl &= 0xFFFF;
                        break;
                    }
                    this.f &= 0x80;
                    break;
                }
                case 58: {
                    this.a = this.addressRead(this.hl--) & 0xFF;
                    break;
                }
                case 59: {
                    this.sp = this.sp - 1 & 0xFFFF;
                    break;
                }
                case 60: {
                    this.a = this.a + 1 & 0xFF;
                    this.f = this.f & 0x10 | this.incflags[this.a];
                    break;
                }
                case 61: {
                    this.a = this.a - 1 & 0xFF;
                    this.f = this.f & 0x10 | this.decflags[this.a];
                    break;
                }
                case 62: {
                    ++this.localPC;
                    this.a = b2;
                    break;
                }
                case 63: {
                    this.f = this.f & 0x90 ^ 0x10;
                    break;
                }
                case 64: {
                    break;
                }
                case 65: {
                    this.b = this.c;
                    break;
                }
                case 66: {
                    this.b = this.d;
                    break;
                }
                case 67: {
                    this.b = this.e;
                    break;
                }
                case 68: {
                    this.b = this.hl >> 8;
                    break;
                }
                case 69: {
                    this.b = this.hl & 0xFF;
                    break;
                }
                case 70: {
                    this.b = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 71: {
                    this.b = this.a;
                    break;
                }
                case 72: {
                    this.c = this.b;
                    break;
                }
                case 73: {
                    break;
                }
                case 74: {
                    this.c = this.d;
                    break;
                }
                case 75: {
                    this.c = this.e;
                    break;
                }
                case 76: {
                    this.c = this.hl >> 8;
                    break;
                }
                case 77: {
                    this.c = this.hl & 0xFF;
                    break;
                }
                case 78: {
                    this.c = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 79: {
                    this.c = this.a;
                    break;
                }
                case 80: {
                    this.d = this.b;
                    break;
                }
                case 81: {
                    this.d = this.c;
                    break;
                }
                case 82: {
                    break;
                }
                case 83: {
                    this.d = this.e;
                    break;
                }
                case 84: {
                    this.d = this.hl >> 8;
                    break;
                }
                case 85: {
                    this.d = this.hl & 0xFF;
                    break;
                }
                case 86: {
                    this.d = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 87: {
                    this.d = this.a;
                    break;
                }
                case 88: {
                    this.e = this.b;
                    break;
                }
                case 89: {
                    this.e = this.c;
                    break;
                }
                case 90: {
                    this.e = this.d;
                    break;
                }
                case 91: {
                    break;
                }
                case 92: {
                    this.e = this.hl >> 8;
                    break;
                }
                case 93: {
                    this.e = this.hl & 0xFF;
                    break;
                }
                case 94: {
                    this.e = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 95: {
                    this.e = this.a;
                    break;
                }
                case 96: {
                    this.hl = this.hl & 0xFF | this.b << 8;
                    break;
                }
                case 97: {
                    this.hl = this.hl & 0xFF | this.c << 8;
                    break;
                }
                case 98: {
                    this.hl = this.hl & 0xFF | this.d << 8;
                    break;
                }
                case 99: {
                    this.hl = this.hl & 0xFF | this.e << 8;
                    break;
                }
                case 100: {
                    break;
                }
                case 101: {
                    this.hl = (this.hl & 0xFF) * 257;
                    break;
                }
                case 102: {
                    this.hl = this.hl & 0xFF | (this.addressRead(this.hl) & 0xFF) << 8;
                    break;
                }
                case 103: {
                    this.hl = this.hl & 0xFF | this.a << 8;
                    break;
                }
                case 104: {
                    this.hl = this.hl & 0xFF00 | this.b;
                    break;
                }
                case 105: {
                    this.hl = this.hl & 0xFF00 | this.c;
                    break;
                }
                case 106: {
                    this.hl = this.hl & 0xFF00 | this.d;
                    break;
                }
                case 107: {
                    this.hl = this.hl & 0xFF00 | this.e;
                    break;
                }
                case 108: {
                    this.hl = (this.hl >> 8) * 257;
                    break;
                }
                case 109: {
                    break;
                }
                case 110: {
                    this.hl = this.hl & 0xFF00 | this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 111: {
                    this.hl = this.hl & 0xFF00 | this.a;
                    break;
                }
                case 112: {
                    this.addressWrite(this.hl, this.b);
                    break;
                }
                case 113: {
                    this.addressWrite(this.hl, this.c);
                    break;
                }
                case 114: {
                    this.addressWrite(this.hl, this.d);
                    break;
                }
                case 115: {
                    this.addressWrite(this.hl, this.e);
                    break;
                }
                case 116: {
                    this.addressWrite(this.hl, this.hl >> 8);
                    break;
                }
                case 117: {
                    this.addressWrite(this.hl, this.hl);
                    break;
                }
                case 118: {
                    this.interruptsEnabled = true;
                    while (!this.interruptsArmed) {
                        this.instrCount = this.nextTimedInterrupt;
                        this.initiateInterrupts();
                    }
                    break;
                }
                case 119: {
                    this.addressWrite(this.hl, this.a);
                    break;
                }
                case 120: {
                    this.a = this.b;
                    break;
                }
                case 121: {
                    this.a = this.c;
                    break;
                }
                case 122: {
                    this.a = this.d;
                    break;
                }
                case 123: {
                    this.a = this.e;
                    break;
                }
                case 124: {
                    this.a = this.hl >> 8;
                    break;
                }
                case 125: {
                    this.a = this.hl & 0xFF;
                    break;
                }
                case 126: {
                    this.a = this.addressRead(this.hl) & 0xFF;
                    break;
                }
                case 127: {
                    break;
                }
                case 167: {
                    if (this.a == 0) {
                        this.f = 160;
                        break;
                    }
                    this.f = 32;
                    break;
                }
                case 175: {
                    this.a = 0;
                    this.f = 128;
                    break;
                }
                case 192: {
                    if (this.f >= 128) break;
                    this.popPC();
                    break;
                }
                case 193: {
                    this.c = this.addressRead(this.sp++) & 0xFF;
                    this.b = this.addressRead(this.sp++) & 0xFF;
                    break;
                }
                case 194: {
                    if (this.f < 128) {
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 195: {
                    this.setPC(((b3 & 0xFF) << 8) + b2);
                    break;
                }
                case 196: {
                    this.localPC += 2;
                    if (this.f >= 128) break;
                    this.pushPC();
                    this.setPC(((b3 & 0xFF) << 8) + b2);
                    break;
                }
                case 197: {
                    this.addressWrite(--this.sp, this.b);
                    this.addressWrite(--this.sp, this.c);
                    break;
                }
                case 198: {
                    ++this.localPC;
                    this.f = (this.a & 0xF) + (b2 & 0xF) >= 16 ? 32 : 0;
                    this.a += b2;
                    if (this.a > 255) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 199: {
                    this.pushPC();
                    this.setPC(0);
                    break;
                }
                case 200: {
                    if (this.f < 128) break;
                    this.popPC();
                    break;
                }
                case 201: {
                    this.popPC();
                    break;
                }
                case 202: {
                    if (this.f >= 128) {
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 203: {
                    ++this.localPC;
                    this.executeShift(b2);
                    break;
                }
                case 204: {
                    this.localPC += 2;
                    if (this.f < 128) break;
                    this.pushPC();
                    this.setPC(((b3 & 0xFF) << 8) + b2);
                    break;
                }
                case 205: {
                    this.localPC += 2;
                    this.pushPC();
                    this.setPC(((b3 & 0xFF) << 8) + b2);
                    break;
                }
                case 206: {
                    ++this.localPC;
                    if ((this.f & 0x10) != 0) {
                        ++b2;
                    }
                    this.f = (this.a & 0xF) + (b2 & 0xF) >= 16 ? 32 : 0;
                    this.a += b2;
                    if (this.a > 255) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 207: {
                    this.pushPC();
                    this.setPC(8);
                    break;
                }
                case 208: {
                    if ((this.f & 0x10) != 0) break;
                    this.popPC();
                    break;
                }
                case 209: {
                    this.e = this.addressRead(this.sp++) & 0xFF;
                    this.d = this.addressRead(this.sp++) & 0xFF;
                    break;
                }
                case 210: {
                    if ((this.f & 0x10) == 0) {
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 212: {
                    this.localPC += 2;
                    if ((this.f & 0x10) != 0) break;
                    this.pushPC();
                    this.setPC(((b3 & 0xFF) << 8) + b2);
                    break;
                }
                case 213: {
                    this.addressWrite(--this.sp, this.d);
                    this.addressWrite(--this.sp, this.e);
                    break;
                }
                case 214: {
                    ++this.localPC;
                    this.f = 64;
                    if ((this.a & 0xF) < (b2 & 0xF)) {
                        this.f |= 0x20;
                    }
                    this.a -= b2;
                    if (this.a < 0) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                        break;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 215: {
                    this.pushPC();
                    this.setPC(16);
                    break;
                }
                case 216: {
                    if ((this.f & 0x10) == 0) break;
                    this.popPC();
                    break;
                }
                case 217: {
                    this.interruptsEnabled = true;
                    this.popPC();
                    break;
                }
                case 218: {
                    if ((this.f & 0x10) != 0) {
                        this.setPC(((b3 & 0xFF) << 8) + b2);
                        break;
                    }
                    this.localPC += 2;
                    break;
                }
                case 220: {
                    this.localPC += 2;
                    if ((this.f & 0x10) == 0) break;
                    this.pushPC();
                    this.setPC(((b3 & 0xFF) << 8) + b2);
                    break;
                }
                case 222: {
                    ++this.localPC;
                    if ((this.f & 0x10) != 0) {
                        ++b2;
                    }
                    this.f = 64;
                    if ((this.a & 0xF) < (b2 & 0xF)) {
                        this.f |= 0x20;
                    }
                    this.a -= b2;
                    if (this.a < 0) {
                        this.f |= 0x10;
                        this.a &= 0xFF;
                        break;
                    }
                    if (this.a != 0) break;
                    this.f |= 0x80;
                    break;
                }
                case 223: {
                    this.pushPC();
                    this.setPC(24);
                    break;
                }
                case 224: {
                    ++this.localPC;
                    this.ioWrite(b2, this.a);
                    break;
                }
                case 225: {
                    this.hl = ((this.addressRead(this.sp + 1) & 0xFF) << 8) + (this.addressRead(this.sp) & 0xFF);
                    this.sp += 2;
                    break;
                }
                case 226: {
                    this.ioWrite(this.c, this.a);
                    break;
                }
                case 229: {
                    this.addressWrite(--this.sp, this.hl >> 8);
                    this.addressWrite(--this.sp, this.hl);
                    break;
                }
                case 230: {
                    ++this.localPC;
                    this.a &= b2;
                    this.f = 0;
                    if (this.a != 0) break;
                    this.f = 128;
                    break;
                }
                case 231: {
                    this.pushPC();
                    this.setPC(32);
                    break;
                }
                case 232: {
                    ++this.localPC;
                    this.sp += offset;
                    this.f = 0;
                    if (this.sp <= 65535 && this.sp >= 0) break;
                    this.sp &= 0xFFFF;
                    this.f = 16;
                    break;
                }
                case 233: {
                    this.setPC(this.hl);
                    break;
                }
                case 234: {
                    this.localPC += 2;
                    this.addressWrite(((b3 & 0xFF) << 8) + b2, this.a);
                    break;
                }
                case 238: {
                    ++this.localPC;
                    this.a ^= b2;
                    this.f = 0;
                    if (this.a != 0) break;
                    this.f = 128;
                    break;
                }
                case 239: {
                    this.pushPC();
                    this.setPC(40);
                    break;
                }
                case 240: {
                    ++this.localPC;
                    if (b2 > 65) {
                        this.a = this.registers[b2] & 0xFF;
                        break;
                    }
                    this.a = this.ioRead(b2) & 0xFF;
                    break;
                }
                case 241: {
                    this.f = this.addressRead(this.sp++) & 0xF0;
                    this.a = this.addressRead(this.sp++) & 0xFF;
                    break;
                }
                case 242: {
                    this.a = this.ioRead(this.c) & 0xFF;
                    break;
                }
                case 243: {
                    this.interruptsEnabled = false;
                    break;
                }
                case 245: {
                    this.addressWrite(--this.sp, this.a);
                    this.addressWrite(--this.sp, this.f);
                    break;
                }
                case 246: {
                    ++this.localPC;
                    this.a |= b2;
                    this.f = 0;
                    if (this.a != 0) break;
                    this.f = 128;
                    break;
                }
                case 247: {
                    this.pushPC();
                    this.setPC(48);
                    break;
                }
                case 248: {
                    ++this.localPC;
                    this.hl = this.sp + offset;
                    this.f = 0;
                    if ((this.hl & 0xFFFF0000) == 0) break;
                    this.f = 16;
                    this.hl &= 0xFFFF;
                    break;
                }
                case 249: {
                    this.sp = this.hl;
                    break;
                }
                case 250: {
                    this.localPC += 2;
                    this.a = this.addressRead(((b3 & 0xFF) << 8) + b2) & 0xFF;
                    break;
                }
                case 251: {
                    this.nextTimedInterrupt = this.nextInterruptEnable = this.instrCount + 1;
                    break;
                }
                case 254: {
                    ++this.localPC;
                    int n = this.f = (this.a & 0xF) < (b2 & 0xF) ? 96 : 64;
                    if (this.a == b2) {
                        this.f |= 0x80;
                        break;
                    }
                    if (this.a >= b2) break;
                    this.f |= 0x10;
                    break;
                }
                case 255: {
                    this.pushPC();
                    this.setPC(56);
                    break;
                }
                default: {
                    if ((b1 & 0xC0) == 128) {
                        int operand = this.registerRead(b1 & 7);
                        switch ((b1 & 0x38) >> 3) {
                            case 1: {
                                if ((this.f & 0x10) != 0) {
                                    ++operand;
                                }
                            }
                            case 0: {
                                this.f = (this.a & 0xF) + (operand & 0xF) >= 16 ? 32 : 0;
                                this.a += operand;
                                if (this.a > 255) {
                                    this.f |= 0x10;
                                    this.a &= 0xFF;
                                }
                                if (this.a != 0) break;
                                this.f |= 0x80;
                                break;
                            }
                            case 3: {
                                if ((this.f & 0x10) != 0) {
                                    ++operand;
                                }
                            }
                            case 2: {
                                this.f = 64;
                                if ((this.a & 0xF) < (operand & 0xF)) {
                                    this.f |= 0x20;
                                }
                                this.a -= operand;
                                if (this.a < 0) {
                                    this.f |= 0x10;
                                    this.a &= 0xFF;
                                }
                                if (this.a != 0) break;
                                this.f |= 0x80;
                                break;
                            }
                            case 4: {
                                this.a &= operand;
                                if (this.a == 0) {
                                    this.f = 160;
                                    break;
                                }
                                this.f = 32;
                                break;
                            }
                            case 5: {
                                this.a ^= operand;
                                this.f = this.a == 0 ? 128 : 0;
                                break;
                            }
                            case 6: {
                                this.a |= operand;
                                this.f = this.a == 0 ? 128 : 0;
                                break;
                            }
                            case 7: {
                                this.f = 64;
                                if (this.a == operand) {
                                    this.f |= 0x80;
                                } else if (this.a < operand) {
                                    this.f |= 0x10;
                                }
                                if ((this.a & 0xF) >= (operand & 0xF)) break;
                                this.f |= 0x20;
                            }
                        }
                        break;
                    }
                    MeBoy.log("Unrecognized opcode (" + Integer.toHexString(b1) + ")");
                    this.terminate = true;
                    GBCanvas gBCanvas = this.screen;
                    gBCanvas.parent.showLog();
                }
            }
            if (this.interruptsArmed && this.interruptsEnabled) {
                this.checkInterrupts();
            }
            if (this.instrCount - this.nextTimedInterrupt < 0) continue;
            this.initiateInterrupts();
        }
    }

    private final void ioHandlerReset() {
        this.ioWrite(15, 1);
        this.ioWrite(38, 241);
        this.ioWrite(64, 145);
        this.ioWrite(71, 252);
        this.ioWrite(72, 255);
        this.ioWrite(73, 255);
    }

    private final int ioRead(int num) {
        if (num == 65) {
            int output = this.registers[65];
            if (this.registers[68] == this.registers[69]) {
                output |= 4;
            }
            if ((this.registers[68] & 0xFF) >= 144) {
                output |= 1;
            } else {
                int cyclePos = this.instrCount - this.nextHBlank + this.INSTRS_PER_HBLANK;
                if (cyclePos > this.INSTRS_IN_MODE_0_2) {
                    output |= 3;
                } else if (cyclePos > this.INSTRS_IN_MODE_0) {
                    output |= 2;
                }
            }
            return output;
        }
        if (num == 4) {
            return (byte)((this.instrCount - this.divReset) / this.INSTRS_PER_DIV);
        }
        if (num == 5) {
            if (this.nextTimaOverflow == Integer.MAX_VALUE) {
                return 0;
            }
            return (this.instrCount + this.instrsPerTima * 256 - this.nextTimaOverflow) / this.instrsPerTima;
        }
        return this.registers[num];
    }

    public void ioWrite(int num, int data) {
        switch (num) {
            case 0: {
                int output = 0;
                if ((data & 0x10) == 0) {
                    output |= this.buttonState & 0xF;
                }
                if ((data & 0x20) == 0) {
                    output |= this.buttonState >> 4;
                }
                this.registers[0] = (byte)(0xF0 | ~output & 0xF);
                break;
            }
            case 2: {
                this.registers[2] = (byte)data;
                if ((this.registers[2] & 1) != 1) break;
                this.registers[1] = -1;
                if ((this.registers[255] & 8) != 0) {
                    this.interruptsArmed = true;
                    this.registers[15] = (byte)(this.registers[15] | 8);
                }
                this.registers[2] = (byte)(this.registers[2] & 0x7F);
                break;
            }
            case 4: {
                this.divReset = this.instrCount;
                break;
            }
            case 5: {
                if (this.nextTimaOverflow >= Integer.MAX_VALUE) break;
                this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - (data & 0xFF));
                break;
            }
            case 7: {
                if ((data & 4) != 0) {
                    int instrsPerSecond = this.INSTRS_PER_HBLANK * 154 * 60;
                    int clockFrequency = data & 3;
                    switch (clockFrequency) {
                        case 0: {
                            this.instrsPerTima = instrsPerSecond / 4096;
                            break;
                        }
                        case 1: {
                            this.instrsPerTima = instrsPerSecond / 262144;
                            break;
                        }
                        case 2: {
                            this.instrsPerTima = instrsPerSecond / 65536;
                            break;
                        }
                        case 3: {
                            this.instrsPerTima = instrsPerSecond / 16384;
                        }
                    }
                    this.nextTimaOverflow = this.instrCount + this.instrsPerTima * (256 - this.registers[6]);
                    break;
                }
                this.nextTimaOverflow = Integer.MAX_VALUE;
                break;
            }
            case 15: {
                this.registers[15] = (byte)data;
                this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                break;
            }
            case 26: {
                this.registers[num] = (byte)data;
                if ((data & 0x80) != 0) break;
                this.registers[38] = (byte)(this.registers[38] & 0xFB);
                break;
            }
            case 64: {
                this.graphicsChip.bgEnabled = true;
                this.graphicsChip.lcdEnabled = (data & 0x80) != 0;
                this.graphicsChip.hiWinTileMapAddress = (data & 0x40) != 0;
                this.graphicsChip.winEnabled = (data & 0x20) != 0;
                this.graphicsChip.bgWindowDataSelect = (data & 0x10) != 0;
                this.graphicsChip.hiBgTileMapAddress = (data & 8) != 0;
                boolean bl = this.graphicsChip.doubledSprites = (data & 4) != 0;
                if ((data & 2) != 0) {
                    this.graphicsChip.spritesEnabled = true;
                    this.graphicsChip.spritesEnabledThisFrame = true;
                } else {
                    this.graphicsChip.spritesEnabled = false;
                }
                if ((data & 1) == 0) {
                    this.graphicsChip.bgEnabled = false;
                    this.graphicsChip.winEnabled = false;
                }
                this.registers[64] = (byte)data;
                break;
            }
            case 65: {
                this.registers[65] = (byte)(data & 0xF8);
                break;
            }
            case 70: {
                System.arraycopy(this.memory[data >> 5], data << 8 & 0x1F00, this.oam, 0, 160);
                break;
            }
            case 71: {
                this.graphicsChip.decodePalette(0, data);
                if (this.registers[71] == (byte)data) break;
                this.registers[71] = (byte)data;
                this.graphicsChip.invalidateAll(0);
                break;
            }
            case 72: {
                this.graphicsChip.decodePalette(4, data);
                if (this.registers[72] == (byte)data) break;
                this.registers[72] = (byte)data;
                this.graphicsChip.invalidateAll(1);
                break;
            }
            case 73: {
                this.graphicsChip.decodePalette(8, data);
                if (this.registers[73] == (byte)data) break;
                this.registers[73] = (byte)data;
                this.graphicsChip.invalidateAll(2);
                break;
            }
            case 74: {
                if ((data & 0xFF) >= 144) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 75: {
                if ((data & 0xFF) >= 167) {
                    this.graphicsChip.stopWindowFromLine();
                }
                this.registers[num] = (byte)data;
                break;
            }
            case 255: {
                this.registers[255] = (byte)data;
                this.interruptsArmed = (this.registers[255] & this.registers[15]) != 0;
                break;
            }
            default: {
                this.registers[num] = (byte)data;
            }
        }
    }

    private final void initCartridge() {
        InputStream is = this.getClass().getResourceAsStream(this.cartName + '0');
        if (is == null) {
            MeBoy.log("ERROR: The cart \"" + this.cartName + "\" does not exist.");
            throw new RuntimeException();
        }
        try {
            byte[] firstBank = new byte[8192];
            int total = 8192;
            while ((total -= is.read(firstBank, 8192 - total, total)) > 0) {
            }
            this.cartType = firstBank[327] & 0xFF;
            int numRomBanks = this.lookUpCartSize(firstBank[328]);
            this.mainRam = new byte[8192];
            if (numRomBanks <= MeBoy.lazyLoadingThreshold) {
                this.rom = new byte[numRomBanks * 2][8192];
                this.rom[0] = firstBank;
                for (int i = 1; i < numRomBanks * 2; ++i) {
                    if ((i & 0xF) == 0) {
                        is.close();
                        is = this.getClass().getResourceAsStream(this.cartName + (i >> 4));
                    }
                    total = 8192;
                    while ((total -= is.read(this.rom[i], 8192 - total, total)) > 0) {
                    }
                }
            } else {
                this.rom = new byte[numRomBanks * 2][];
                this.rom[0] = firstBank;
                this.rom[1] = new byte[8192];
                MeBoy.log("Partial loading active.");
                total = 8192;
                while ((total -= is.read(this.rom[1], 8192 - total, total)) > 0) {
                }
                this.loadedRomBanks = 1;
                this.romBankQueue = new int[MeBoy.lazyLoadingThreshold];
            }
            is.close();
            this.memory[0] = this.rom[0];
            this.memory[1] = this.rom[1];
            this.romTouch = new int[this.rom.length / 2];
            this.mapRom(1);
            int numRamBanks = this.getNumRAMBanks();
            MeBoy.log("Loaded '" + this.cartName + "'. " + numRomBanks + " banks = " + numRomBanks * 16 + " kB, " + numRamBanks + " RAM banks.");
            MeBoy.log("Type: " + this.cartType + " (bw)");
            if (this.cartType == 6 && numRamBanks == 0) {
                numRamBanks = 1;
            }
            this.cartRam = new byte[numRamBanks][8192];
            if (numRamBanks > 0) {
                this.memory[5] = this.cartRam[0];
            }
            this.lastRtcUpdate = (int)System.currentTimeMillis();
        }
        catch (Exception e) {
            MeBoy.log("ERROR: Loading the cart \"" + this.cartName + "\" failed.");
            MeBoy.log(e.toString());
            throw new RuntimeException();
        }
    }

    private final void mapRom(int bankNo) {
        this.currentRomBank = bankNo;
        this.romTouch[bankNo] = this.instrCount;
        if (this.rom[bankNo * 2] == null) {
            try {
                int i;
                byte[][] newmem = new byte[2][];
                if (this.loadedRomBanks >= MeBoy.lazyLoadingThreshold) {
                    int candidate = 0;
                    int candidateAge = Integer.MIN_VALUE;
                    int bankCount = this.rom.length >> 1;
                    for (i = 1; i < bankCount; ++i) {
                        int age;
                        if (this.rom[i * 2] == null || (age = this.instrCount - this.romTouch[i]) <= candidateAge) continue;
                        candidateAge = age;
                        candidate = i;
                    }
                    newmem[0] = this.rom[candidate * 2];
                    newmem[1] = this.rom[candidate * 2 + 1];
                    this.rom[candidate * 2] = null;
                    this.rom[candidate * 2 + 1] = null;
                } else {
                    newmem[0] = new byte[8192];
                    newmem[1] = new byte[8192];
                    this.romBankQueue[this.loadedRomBanks] = bankNo;
                    ++this.loadedRomBanks;
                }
                int file = bankNo >> 3;
                int offset = (bankNo & 7) * 16384;
                InputStream is = this.getClass().getResourceAsStream(this.cartName + file);
                if (is.skip(offset) != (long)offset) {
                    throw new RuntimeException("failed skipping to " + bankNo);
                }
                for (i = bankNo * 2; i < bankNo * 2 + 2; ++i) {
                    int total = 8192;
                    this.rom[i] = newmem[i & 1];
                    while ((total -= is.read(this.rom[i], 8192 - total, total)) > 0) {
                    }
                }
                is.close();
            }
            catch (Exception e) {
                MeBoy.log("ERROR: Lazy loading the cart \"" + this.cartName + "\" failed.");
                MeBoy.log(e.toString());
                throw new RuntimeException();
            }
        }
        this.memory[2] = this.rom[bankNo * 2];
        this.memory[3] = this.rom[bankNo * 2 + 1];
        if ((this.globalPC & 0xC000) == 16384) {
            this.setPC(this.localPC + this.globalPC);
        }
    }

    private final void mapRam(int bankNo) {
        this.currentRamBank = bankNo;
        if (this.currentRamBank <= this.cartRam.length) {
            this.memory[5] = this.cartRam[bankNo];
        }
    }

    private final void cartridgeWrite(int addr, int data) {
        int halfbank = addr >> 13;
        int subaddr = addr & 0x1FFF;
        switch (this.cartType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (halfbank == 5) {
                    if (!this.cartRamEnabled) break;
                    this.memory[halfbank][subaddr] = (byte)data;
                    break;
                }
                if (halfbank == 1) {
                    int bankNo = data & 0x1F;
                    if (bankNo == 0) {
                        bankNo = 1;
                    }
                    this.mapRom(this.currentRomBank & 0x60 | bankNo);
                    break;
                }
                if (halfbank == 3) {
                    this.mbc1LargeRamMode = (data & 1) == 1;
                    break;
                }
                if (halfbank == 0) {
                    this.cartRamEnabled = (data & 0xF) == 10;
                    break;
                }
                if (halfbank != 2) break;
                if (this.mbc1LargeRamMode) {
                    this.mapRam(data & 3);
                    break;
                }
                this.mapRom(this.currentRomBank & 0x1F | (data & 3) << 5);
                break;
            }
            case 5: 
            case 6: {
                if (halfbank == 1) {
                    if ((addr & 0x100) != 0) {
                        int bankNo = data & 0xF;
                        if (bankNo == 0) {
                            bankNo = 1;
                        }
                        this.mapRom(bankNo);
                    } else {
                        boolean bl = this.cartRamEnabled = (data & 0xF) == 10;
                    }
                }
                if (halfbank != 5 || !this.cartRamEnabled) break;
                this.memory[halfbank][subaddr] = (byte)data;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (halfbank == 1) {
                    int bankNo = data & 0x7F;
                    if (bankNo == 0) {
                        bankNo = 1;
                    }
                    this.mapRom(bankNo);
                    break;
                }
                if (halfbank == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(data);
                    break;
                }
                if (halfbank != 5) break;
                if (this.currentRamBank >= 8) {
                    this.rtcSync();
                    this.rtcReg[this.currentRamBank - 8] = (byte)data;
                    break;
                }
                this.memory[halfbank][subaddr] = (byte)data;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (addr >> 12 == 2) {
                    int bankNo = this.currentRomBank & 0xFF00 | data;
                    this.mapRom(bankNo);
                    break;
                }
                if (addr >> 12 == 3) {
                    int bankNo = this.currentRomBank & 0xFF | (data & 1) << 8;
                    this.mapRom(bankNo);
                    break;
                }
                if (halfbank == 2) {
                    if (this.cartRam.length <= 0) break;
                    this.mapRam(data & 7);
                    break;
                }
                if (halfbank != 5 || this.memory[5] == null) break;
                this.memory[halfbank][subaddr] = (byte)data;
            }
        }
    }

    protected final void rtcSync() {
        if ((this.rtcReg[4] & 0x40) == 0) {
            int now = (int)System.currentTimeMillis();
            while (now - this.lastRtcUpdate > 1000) {
                this.lastRtcUpdate += 1000;
                this.rtcReg[0] = (byte)(this.rtcReg[0] + 1);
                if (this.rtcReg[0] != 60) continue;
                this.rtcReg[0] = 0;
                this.rtcReg[1] = (byte)(this.rtcReg[1] + 1);
                if (this.rtcReg[1] != 60) continue;
                this.rtcReg[1] = 0;
                this.rtcReg[2] = (byte)(this.rtcReg[2] + 1);
                if (this.rtcReg[2] != 24) continue;
                this.rtcReg[2] = 0;
                this.rtcReg[3] = (byte)(this.rtcReg[3] + 1);
                if (this.rtcReg[3] != 0) continue;
                this.rtcReg[4] = (byte)((this.rtcReg[4] | this.rtcReg[4] << 7) ^ 1);
            }
        }
    }

    public final void rtcSkip(int s) {
        int sum = s + this.rtcReg[0];
        this.rtcReg[0] = (byte)(sum % 60);
        if ((sum /= 60) == 0) {
            return;
        }
        this.rtcReg[1] = (byte)((sum += this.rtcReg[1]) % 60);
        if ((sum /= 60) == 0) {
            return;
        }
        this.rtcReg[2] = (byte)((sum += this.rtcReg[2]) % 24);
        if ((sum /= 24) == 0) {
            return;
        }
        sum = sum + (this.rtcReg[3] & 0xFF) + ((this.rtcReg[4] & 1) << 8);
        this.rtcReg[3] = (byte)sum;
        if (sum > 511) {
            this.rtcReg[4] = (byte)(this.rtcReg[4] | 0x80);
        }
        this.rtcReg[4] = (byte)((this.rtcReg[4] & 0xFE) + (sum >> 8 & 1));
    }

    private final int getNumRAMBanks() {
        switch (this.rom[0][329]) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: 
            case 5: 
            case 6: {
                return 16;
            }
        }
        return 0;
    }

    private final int lookUpCartSize(int sizeByte) {
        if (sizeByte < 8) {
            return 2 << sizeByte;
        }
        if (sizeByte == 82) {
            return 72;
        }
        if (sizeByte == 83) {
            return 80;
        }
        if (sizeByte == 84) {
            return 96;
        }
        return -1;
    }

    public final boolean hasBattery() {
        return this.cartType == 3 || this.cartType == 9 || this.cartType == 27 || this.cartType == 30 || this.cartType == 6 || this.cartType == 16 || this.cartType == 19;
    }

    public void buttonDown(int buttonIndex) {
        this.buttonState |= 1 << buttonIndex;
        this.p10Requested = true;
        this.interruptsArmed = true;
    }

    public void buttonUp(int buttonIndex) {
        this.buttonState &= 255 - (1 << buttonIndex);
        this.p10Requested = true;
        this.interruptsArmed = true;
    }

    public void setScale(int screenWidth, int screenHeight) {
        this.graphicsChip.setScale(screenWidth, screenHeight);
    }

    public int getTileWidth() {
        return this.graphicsChip.tileWidth;
    }

    public int getTileHeight() {
        return this.graphicsChip.tileHeight;
    }

    public void setTranslation(int left, int top) {
        this.graphicsChip.left = left;
        this.graphicsChip.top = top;
    }

    public int getLastSkipCount() {
        return this.graphicsChip.lastSkipCount;
    }

    public void draw(Graphics g) {
        this.graphicsChip.draw(g);
    }

    public void terminate() {
        this.terminate = true;
    }

    public boolean isTerminated() {
        return this.terminate;
    }

    public byte[] getRtcReg() {
        return this.rtcReg;
    }

    public byte[][] getCartRam() {
        return this.cartRam;
    }
}

